#include <SPI.h>
#include <Fpu64.h>
#include <FpuSerial64.h>

//-------------------- local prototypes ---------------------------------------

//-------------------- uM-FPU register definitions --------------------------

//-------------------- uM-FPU Function Definitions -----------------------------
#define COG_LCD_init    1               // uM-FPU user function
#define COG_LCD_test    2               // uM-FPU user function
#define COG_LCD_clear   3               // uM-FPU user function
#define COG_LCD_drawClear   4           // uM-FPU user function
#define COG_LCD_penType 5               // uM-FPU user function
#define COG_LCD_fontSize    6           // uM-FPU user function
#define COG_LCD_drawLine    7           // uM-FPU user function
#define COG_LCD_drawRect    8           // uM-FPU user function
#define COG_LCD_fillRect    9           // uM-FPU user function
#define COG_LCD_drawString  10          // uM-FPU user function
#define COG_LCD_writeChar   11          // uM-FPU user function
#define COG_LCD_writeCharColumn 12      // uM-FPU user function
#define COG_LCD_writeColumn 13          // uM-FPU user function
#define COG_LCD_update  14              // uM-FPU user function
#define font_data   15                  // uM-FPU user function

//-------------------- setup ------------------------------------------------

void setup()
{
  Serial.begin(9600);
  Serial.println("test COG_LCD");
  
  SPI.begin();
  Fpu.begin();

  // Check for synchronization and display FPU version
  // (note: this is optional code)
  if (Fpu.sync() == SYNC_CHAR)
    FpuSerial.printVersionln();
  else
  {
    Serial.print("uM-FPU not detected");
    while(1) ; // stop if FPU not detected
  }
  
  Fpu.write(FCALL, COG_LCD_init);
  Fpu.wait();
  
  Fpu.write(FCALL, COG_LCD_test);
}

//-------------------- loop -------------------------------------------------

void loop()
{
}

